SuperStrict

' Example 7: WAV File Export
' Demonstrates: SpeakToFileDefault(), SpeakToFile()

Framework BRL.StandardIO
Import BRL.FileSystem

Import "-L."
Import "-lBlitzSpeech"
Include "BlitzSpeechH.bmx"

Print "BlitzSpeech - WAV File Export Example"

Print ""

If InitSpeech() = SP_INIT_SUCCESS Then
    
    Local text:String = "This is a test of WAV file export."
    
    ' Export with default quality (22kHz, 16-bit, mono)
    Print "Exporting to: output_default.wav (default quality)"
    Local result:Int = SpeakToFileDefault(text, "output_default.wav")
    If result = SP_FILE_OUT_SUCCESS Then
        Print "  Success! File created."
    Else
        Print "  ERROR: Failed (code: " + result + ")"
    End If
    Print ""
    
    ' Export with CD quality (44.1kHz, 16-bit, stereo)
    Print "Exporting to: output_cd.wav (CD quality)"
    result = SpeakToFile(text, "output_cd.wav", SP_SAMPLE_RATE_44100, SP_BIT_DEPTH_16, SP_CHANNEL_STEREO, SPF_DEFAULT)
    If result = SP_FILE_OUT_SUCCESS Then
        Print "  Success! File created."
    Else
        Print "  ERROR: Failed (code: " + result + ")"
    End If
    Print ""
    
    ' Export with low quality (8kHz, 8-bit, mono)
    Print "Exporting to: output_low.wav (low quality - small file)"
    result = SpeakToFile(text, "output_low.wav", SP_SAMPLE_RATE_8000, SP_BIT_DEPTH_8, SP_CHANNEL_MONO, SPF_DEFAULT)
    If result = SP_FILE_OUT_SUCCESS Then
        Print "  Success! File created."
    Else
        Print "  ERROR: Failed (code: " + result + ")"
    End If
    Print ""
    
    ' Export with high quality (48kHz, 16-bit, stereo)
    Print "Exporting to: output_high.wav (high quality)"
    result = SpeakToFile(text, "output_high.wav", SP_SAMPLE_RATE_48000, SP_BIT_DEPTH_16, SP_CHANNEL_STEREO, SPF_DEFAULT)
    If result = SP_FILE_OUT_SUCCESS Then
        Print "  Success! File created."
    Else
        Print "  ERROR: Failed (code: " + result + ")"
    End If
    Print ""
    
    ' Show file sizes
    Print "File sizes:"
    If FileType("output_low.wav") = 1 Then
        Print "  output_low.wav: " + FileSize("output_low.wav") + " bytes (8kHz, 8-bit, mono)"
    End If
    If FileType("output_default.wav") = 1 Then
        Print "  output_default.wav: " + FileSize("output_default.wav") + " bytes (22kHz, 16-bit, mono)"
    End If
    If FileType("output_cd.wav") = 1 Then
        Print "  output_cd.wav: " + FileSize("output_cd.wav") + " bytes (44kHz, 16-bit, stereo)"
    End If
    If FileType("output_high.wav") = 1 Then
        Print "  output_high.wav: " + FileSize("output_high.wav") + " bytes (48kHz, 16-bit, stereo)"
    End If
    Print ""
    
    CleanupSpeech()
    Print "Done! Check the output WAV files."
Else
    Print "Failed to initialize speech!"
EndIf

Print ""
Print "Press ENTER to exit..."
Input ""